
from gurobipy import *

# Create a new model
m = Model("Sneaker_Optimization")

# Define the decision variables
x_A = m.addVar(lb=0, vtype=GRB.INTEGER, name="Brand_A_Sneakers")
x_B = m.addVar(lb=0, vtype=GRB.INTEGER, name="Brand_B_Sneakers")

# Define the objective function
m.setObjective(50*x_A + 75*x_B, GRB.MAXIMIZE)

# Define the constraints
m.addConstr(100*x_A + 150*x_B <= 2000, "Budget_Constraint")
m.addConstr(x_A + x_B <= 15, "Total_Sneakers_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy and sell {x_A.x} Brand A sneakers")
    print(f"Buy and sell {x_B.x} Brand B sneakers")
    print(f"Total profit: ${m.objVal}")
else:
    print("No optimal solution found")
