
import gurobi

def solve_sneaker_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_A = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Brand_A")
    x_B = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Brand_B")

    # Objective function: Maximize profit
    model.setObjective(50 * x_A + 75 * x_B, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(100 * x_A + 150 * x_B <= 2000, name="Budget_Constraint")

    # Sales constraint
    model.addConstr(x_A + x_B <= 15, name="Sales_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Buying and selling {x_A.varName} = {x_A.x} and {x_B.varName} = {x_B.x} maximizes profit.")
    else:
        print("No optimal solution found.")

solve_sneaker_problem()
