
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Emma's Diet")

# Create variables
x = m.addVar(lb=0, name="Pork")  # Units of pork
y = m.addVar(lb=0, name="Shrimp") # Units of shrimp

# Set objective function
m.setObjective(3*x + 5.5*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(15*x + 22*y >= 120, "Protein_req")
m.addConstr(4*x + 7*y >= 30, "Fat_req")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Units of Pork: {x.x:.2f}")
    print(f"Units of Shrimp: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

