
from gurobipy import *

# Create a new model
m = Model("Emma_Diet")

# Define the decision variables
pork = m.addVar(lb=0, name="pork")
shrimp = m.addVar(lb=0, name="shrimp")

# Set the objective function
m.setObjective(3*pork + 5.5*shrimp, GRB.MINIMIZE)

# Add constraints
m.addConstr(15*pork + 22*shrimp >= 120, "Protein_Requirement")
m.addConstr(4*pork + 7*shrimp >= 30, "Fat_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pork: {pork.x}")
    print(f"Shrimp: {shrimp.x}")
    print(f"Total Cost: ${3*pork.x + 5.5*shrimp.x:.2f}")
else:
    print("No optimal solution found")
