
import gurobi

def solve_diet_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(lb=0, name="pork")
    x2 = model.addVar(lb=0, name="shrimp")

    # Define the objective function
    model.setObjective(3 * x1 + 5.5 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(15 * x1 + 22 * x2 >= 120, name="protein_requirement")
    model.addConstr(4 * x1 + 7 * x2 >= 30, name="fat_requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is infeasible
    if model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible")
        return

    # Print the solution
    print("Optimal solution:")
    print(f"Pork: {x1.varValue}")
    print(f"Shrimp: {x2.varValue}")
    print(f"Total cost: {model.objVal}")

solve_diet_problem()
