
import gurobipy as gp

# Create a new model
m = gp.Model("concrete_mix")

# Create variables
x = m.addVar(nonneg=True, name="mix_A")
y = m.addVar(nonneg=True, name="mix_B")

# Set objective function
m.setObjective(1*x + 1.25*y, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x + 6*y >= 70, "cement")
m.addConstr(2*x + 1*y >= 20, "sand")
m.addConstr(1*x + 2*y >= 15, "gravel")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Mix A: {x.x}")
    print(f"Mix B: {y.x}")
    print(f"Minimum Cost: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

