
from gurobipy import *

# Create a new model
m = Model("Concrete_Mix_Optimization")

# Define the decision variables
x_A = m.addVar(name="Mix_A", vtype=GRB.CONTINUOUS, lb=0)
x_B = m.addVar(name="Mix_B", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(1*x_A + 1.25*x_B, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x_A + 6*x_B >= 70, name="Cement_Constraint")
m.addConstr(2*x_A + x_B >= 20, name="Sand_Constraint")
m.addConstr(x_A + 2*x_B >= 15, name="Gravel_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mix A: {x_A.x}")
    print(f"Mix B: {x_B.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")
