
import gurobi

def solve_concrete_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="mix_A", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="mix_B", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: Minimize cost
    model.setObjective(x + 1.25 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * x + 6 * y >= 70, name="cement_constraint")
    model.addConstr(2 * x + y >= 20, name="sand_constraint")
    model.addConstr(x + 2 * y >= 15, name="gravel_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: {model.objVal}")
        print(f"Units of mix A: {x.varValue}")
        print(f"Units of mix B: {y.varValue}")
    else:
        print("No optimal solution found")

solve_concrete_mix_problem()
