
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("monitor_production")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="LCD_monitors")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="LED_monitors")

# Set objective function
m.setObjective(25*x + 70*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 150, "demand_LCD")
m.addConstr(y >= 80, "demand_LED")
m.addConstr(x <= 300, "capacity_LCD")
m.addConstr(y <= 280, "capacity_LED")
m.addConstr(x + y >= 250, "total_monitors")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of LCD monitors to produce: {x.x}")
    print(f"Number of LED monitors to produce: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

