
from gurobipy import *

# Create a new model
m = Model("Monitor_Production")

# Add variables
x = m.addVar(name="LCD_Monitors", lb=150, ub=300)  # Number of LCD monitors
y = m.addVar(name="LED_Monitors", lb=80, ub=280)   # Number of LED monitors

# Set the objective function
m.setObjective(25*x + 70*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y >= 250, name="Total_Monitors_Requirement")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"LCD Monitors: {x.x}")
    print(f"LED Monitors: {y.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
