
import gurobi

def solve_monitor_production():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="LCD_monitors")  # Number of LCD monitors
    y = model.addVar(lb=0, name="LED_monitors")  # Number of LED monitors

    # Objective function: Maximize profit
    model.setObjective(25 * x + 70 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x >= 150, name="LCD_demand")  # LCD demand constraint
    model.addConstr(y >= 80, name="LED_demand")  # LED demand constraint
    model.addConstr(x <= 300, name="LCD_production_limit")  # LCD production limit
    model.addConstr(y <= 280, name="LED_production_limit")  # LED production limit
    model.addConstr(x + y >= 250, name="total_monitors_contract")  # Total monitors contract constraint

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal LCD monitors: {x.varValue}")
        print(f"Optimal LED monitors: {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model did not find an optimal solution.")

solve_monitor_production()
