
import gurobipy as gp

# Create a new model
model = gp.Model("Seafood Medley Optimization")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="Seafood Medley One")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="Seafood Medley Two")


# Set objective function
model.setObjective(20*x + 25*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x + 40*y <= 10000, "Scallops Constraint")
model.addConstr(30*x + 40*y <= 12000, "Mussels Constraint")
model.addConstr(50*x + 20*y <= 11000, "Oysters Constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Seafood Medley One (x): {x.x}")
    print(f"Seafood Medley Two (y): {y.x}")
    print(f"Optimal Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {model.status}")

