
from gurobipy import *

# Create a new model
m = Model("Seafood_Medley")

# Define the decision variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="seafood_medley_one")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="seafood_medley_two")

# Set the objective function
m.setObjective(20*x1 + 25*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 40*x2 <= 10000, "scallops")
m.addConstr(30*x1 + 40*x2 <= 12000, "mussels")
m.addConstr(50*x1 + 20*x2 <= 11000, "oysters")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Seafood Medley One: {x1.x}")
    print(f"Seafood Medley Two: {x2.x}")
    print(f"Total Profit: ${20*x1.x + 25*x2.x:.2f}")
else:
    print("No optimal solution found")
