
import gurobipy as gp

# Create a new model
model = gp.Model("Seafood Medley Optimization")

# Define the decision variables
x1 = model.addVar(name="seafood_medley_one", lb=0, ub=gp.GRB.INFINITY)
x2 = model.addVar(name="seafood_medley_two", lb=0, ub=gp.GRB.INFINITY)

# Define the objective function
model.setObjective(20 * x1 + 25 * x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(20 * x1 + 40 * x2 <= 10000, name="scallops_constraint")
model.addConstr(30 * x1 + 40 * x2 <= 12000, name="mussels_constraint")
model.addConstr(50 * x1 + 20 * x2 <= 11000, name="oysters_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Seafood Medley One: {x1.varValue}")
    print(f"Seafood Medley Two: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
