
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("stationary_store")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="pens") # Number of pens
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="pencils") # Number of pencils

# Set objective function
m.setObjective(3*x + 1*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + y <= 500, "inventory_cost")
m.addConstr(x >= 100, "min_pens")
m.addConstr(x <= 150, "max_pens")
m.addConstr(y <= 2*x, "max_pencils")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of pens to buy and sell: {x.x}")
    print(f"Number of pencils to buy and sell: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

