
from gurobipy import *

# Create a new model
m = Model("Stationary_Store_Profit")

# Decision Variables
x_p = m.addVar(lb=100, ub=150, vtype=GRB.INTEGER, name="pens")
x_c = m.addVar(vtype=GRB.INTEGER, name="pencils")

# Objective Function: Maximize profit
m.setObjective(3*x_p + x_c, GRB.MAXIMIZE)

# Constraints
m.addConstr(2*x_p + x_c <= 500, "cost_constraint")
m.addConstr(x_c <= 2*x_p, "pencil_sales_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Buy and sell {x_p.x} pens.")
    print(f"Buy and sell {x_c.x} pencils.")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")

