
import gurobi

def solve_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=100, ub=150, name="Pens")
    y = model.addVar(lb=0, name="Pencils")

    # Objective function: Maximize profit
    model.setObjective(3*x + y, gurobi.GRB.MAXIMIZE)

    # Inventory cost constraint
    model.addConstr(2*x + y <= 500, name="Inventory_Cost")

    # Pencil sales constraint
    model.addConstr(y <= 2*x, name="Pencil_Sales")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Pens = {x.varValue}, Pencils = {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_problem()
