
import gurobipy as gp

# Create a new model
model = gp.Model("Nut_Mix_Problem")

# Create decision variables
x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")

# Set objective function
model.setObjective(10*x1 + 12*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x1 + 15*x2 <= 1000, "Almond_Constraint")
model.addConstr(30*x1 + 20*x2 <= 1200, "Pecan_Constraint")
model.addConstr(10*x1 + 25*x2 <= 1100, "Pistachio_Constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Mixture 1 packages: {x1.x}")
    print(f"Number of Mixture 2 packages: {x2.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

