
from gurobipy import *

# Create a model
m = Model("Grocery_Store_Optimization")

# Define variables
x = m.addVar(lb=0, name="Mixture_1")
y = m.addVar(lb=0, name="Mixture_2")

# Objective function: Maximize profit
m.setObjective(10*x + 12*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*x + 15*y <= 1000, "Almonds_Constraint")
m.addConstr(30*x + 20*y <= 1200, "Pecans_Constraint")
m.addConstr(10*x + 25*y <= 1100, "Pistachios_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum profit: ${10*x.x + 12*y.x:.2f}")
else:
    print("The model is infeasible")
