
import gurobipy as gp

# Create a new model
model = gp.Model("NutMixture")

# Define variables
x1 = model.addVar(name="Mixture1", lb=0)  # Number of Mixture 1
x2 = model.addVar(name="Mixture2", lb=0)  # Number of Mixture 2

# Define objective function
model.setObjective(10*x1 + 12*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x1 + 15*x2 <= 1000, name="AlmondConstraint")
model.addConstr(30*x1 + 20*x2 <= 1200, name="PecanConstraint")
model.addConstr(10*x1 + 25*x2 <= 1100, name="PistachioConstraint")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Mixture 1 = {x1.varValue}, Mixture 2 = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
