
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="wheat_acres")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_acres")

# Set objective function
m.setObjective(50*x + 90*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 90, "land_constraint")
m.addConstr(10*x + 20*y <= 1400, "maintenance_constraint")
m.addConstr(4*x + 3*y <= 90, "care_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x} acres of wheat")
    print(f"Plant {y.x} acres of corn")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

