
from gurobipy import *

# Create a model
m = Model("Farm_Profit")

# Define the decision variables
w = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="wheat_acres")
c = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_acres")

# Objective function: Maximize profit
m.setObjective(50*w + 90*c, GRB.MAXIMIZE)

# Constraints
m.addConstr(10*w + 20*c <= 1400, "maintenance_budget")
m.addConstr(4*w + 3*c <= 90, "care_time")
m.addConstr(w + c <= 90, "land_availability")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Wheat acres: {w.x}")
    print(f"Corn acres: {c.x}")
    print(f"Maximum profit: ${50*w.x + 90*c.x:.2f}")
else:
    print("No optimal solution found")
