
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    W = model.addVar(lb=0, name="Wheat_Acres")
    C = model.addVar(lb=0, name="Corn_Acres")

    # Objective function: Maximize profit
    model.setObjective(50 * W + 90 * C, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(W + C <= 90, name="Land_Constraint")
    model.addConstr(10 * W + 20 * C <= 1400, name="Maintenance_Cost_Constraint")
    model.addConstr(4 * W + 3 * C <= 90, name="Care_Hours_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of wheat: {W.varValue}")
        print(f"Optimal acres of corn: {C.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The problem is infeasible")

if __name__ == "__main__":
    solve_optimization_problem()
