
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("FerryTicketOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="regular_tickets")
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="concession_tickets")

# Set objective function
model.setObjective(2*x + 0.5*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 120, "capacity")
model.addConstr(y >= 15, "min_concession")
model.addConstr(x >= 5*y, "ratio")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular tickets: {x.x}")
    print(f"Number of concession tickets: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

