
from gurobipy import *

# Create a model
m = Model("Ferry_Ticket_Sales")

# Define decision variables
x_r = m.addVar(vtype=GRB.CONTINUOUS, name="regular_tickets")
x_c = m.addVar(vtype=GRB.CONTINUOUS, name="concession_tickets")

# Set the objective function to maximize profit
m.setObjective(2*x_r + 0.5*x_c, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_r + x_c <= 120, "total_capacity")
m.addConstr(x_c >= 15, "concession_minimum")
m.addConstr(x_r >= 5*x_c, "regular_to_concession_ratio")

# Optimize the model
m.optimize()

# Print results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular tickets sold: {x_r.x}")
    print(f"Concession tickets sold: {x_c.x}")
    print(f"Maximum profit: ${2*x_r.x + 0.5*x_c.x:.2f}")
else:
    print("No optimal solution found")
