
import gurobi

def solve_ferry_ticket_problem():
    # Create a new model
    m = gurobi.Model()

    # Decision variables
    x_r = m.addVar(name="regular_tickets", lb=0, vtype=gurobi.GRB.INTEGER)
    x_c = m.addVar(name="concession_tickets", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    m.setObjective(2 * x_r + 0.5 * x_c, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(x_r + x_c <= 120, name="capacity_constraint")
    m.addConstr(x_c >= 15, name="concession_reservation")
    m.addConstr(x_r >= 5 * x_c, name="regular_concession_ratio")

    # Solve the problem
    m.optimize()

    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Regular Tickets = {x_r.varValue}, Concession Tickets = {x_c.varValue}")
        print(f"Max Profit: {m.objVal}")
    else:
        print("The problem is infeasible")

solve_ferry_ticket_problem()
