
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("MovieTheatreSeating")

# Create decision variables
z = model.addVar(lb=0, vtype=GRB.INTEGER, name="zero_gravity_seats")
s = model.addVar(lb=0, vtype=GRB.INTEGER, name="standard_seats")

# Set objective function
model.setObjective(55*z + 25*s, GRB.MAXIMIZE)

# Add constraints
model.addConstr(z + s <= 250, "capacity")
model.addConstr(z >= 40, "min_zero_gravity")
model.addConstr(s >= 4*z, "standard_preference")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${model.objVal:.2f}")
    print(f"Zero Gravity Seats: {z.x}")
    print(f"Standard Seats: {s.x}")
else:
    print("Infeasible or unbounded model.")

