
from gurobipy import *

# Create a new model
m = Model("Movie_Theatre_Seating")

# Define the variables
Z = m.addVar(vtype=GRB.INTEGER, name="Zero_Gravity_Seats")
S = m.addVar(vtype=GRB.INTEGER, name="Standard_Seats")

# Set the objective function: Maximize profit
m.setObjective(55*Z + 25*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(Z + S <= 250, "Total_Capacity")
m.addConstr(Z >= 40, "Minimum_Zero_Gravity_Seats")
m.addConstr(S >= 4*Z, "Preference")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Zero Gravity Seats: {Z.x}")
    print(f"Standard Seats: {S.x}")
    print(f"Total Profit: ${55*Z.x + 25*S.x:.2f}")
else:
    print("No optimal solution found")
