
import gurobipy as gp

# Create a new model
model = gp.Model("Movie_Theatre_Optimization")

# Decision variables
x = model.addVar(lb=40, name="zero_gravity_seats")  # Minimum 40 zero gravity seats
y = model.addVar(name="standard_seats")

# Objective function: Maximize profit
model.setObjective(55 * x + 25 * y, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x + y <= 250, name="total_seats")  # Total seats not exceeding 250
model.addConstr(y >= 4 * x, name="standard_to_zero_gravity_ratio")  # Standard seats to zero gravity ratio

# Solve the model
model.solve()

# Output solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Zero gravity seats = {x.varValue}, Standard seats = {y.varValue}")
    print(f"Maximum profit: ${55 * x.varValue + 25 * y.varValue}")
else:
    print("No optimal solution found")
