
import gurobipy as gp

# Create a new model
model = gp.Model("TeddyBearProduction")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="small_teddy_bears")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="large_teddy_bears")

# Set the objective function
model.setObjective(50*x + 8*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(5*x + 10*y <= 700, "filling_constraint")
model.addConstr(25*x + 35*y <= 900, "stitching_constraint")
model.addConstr(x >= 0, "small_non_negativity")
model.addConstr(y >= 0, "large_non_negativity")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small teddy bears: {x.x}")
    print(f"Number of large teddy bears: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

