
from gurobipy import *

# Create a model
m = Model("TeddyBearProduction")

# Decision variables
S = m.addVar(vtype=GRB.CONTINUOUS, name="SmallTeddyBears")
L = m.addVar(vtype=GRB.CONTINUOUS, name="LargeTeddyBears")

# Objective function: Maximize profits
m.setObjective(50*S + 8*L, GRB.MAXIMIZE)

# Constraints
m.addConstr(5*S + 10*L <= 700, "FillingTime")
m.addConstr(25*S + 35*L <= 900, "StitchingTime")

# Non-negativity constraints
m.addConstr(S >= 0, "NonNegativeSmall")
m.addConstr(L >= 0, "NonNegativeLarge")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of small teddy bears: {S.x}")
    print(f"Number of large teddy bears: {L.x}")
    print(f"Total profit: ${50*S.x + 8*L.x:.2f}")
else:
    print("No optimal solution found.")
