
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
x = m.addVar(lb=0, name="small_teddy_bears")
y = m.addVar(lb=0, name="large_teddy_bears")

# Define the objective function
m.setObjective(50 * x + 8 * y, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(5 * x + 10 * y <= 700, name="filling_time")
m.addConstr(25 * x + 35 * y <= 900, name="stitching_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of small teddy bears: {x.varValue}")
    print(f"Number of large teddy bears: {y.varValue}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")
