
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("coffee_pods")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="small_pods") # Number of small pods
y = m.addVar(vtype=GRB.INTEGER, name="large_pods") # Number of large pods

# Set objective function
m.setObjective(3*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x + 20*y <= 2000, "coffee_availability")
m.addConstr(x >= 4*y, "small_large_ratio")
m.addConstr(y >= 10, "min_large_pods")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small coffee pods (x): {x.x}")
    print(f"Number of large coffee pods (y): {y.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

