
from gurobipy import *

# Create a new model
m = Model("Coffee_Pod_Optimization")

# Define the decision variables
x_s = m.addVar(vtype=GRB.INTEGER, name="small_pods")
x_l = m.addVar(vtype=GRB.INTEGER, name="large_pods")

# Objective function: Maximize profit
m.setObjective(3*x_s + 5*x_l, GRB.MAXIMIZE)

# Constraints
m.addConstr(15*x_s + 20*x_l <= 2000, "coffee_availability")
m.addConstr(x_s >= 4*x_l, "small_to_large_ratio")
m.addConstr(x_l >= 10, "minimum_large_pods")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Small pods: {x_s.x}")
    print(f"Large pods: {x_l.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
