
import gurobi

def solve_coffee_pod_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    S = model.addVar(name="Small_Coffee_Pods", vtype=gurobi.GRB.INTEGER, lb=0)
    L = model.addVar(name="Large_Coffee_Pods", vtype=gurobi.GRB.INTEGER, lb=10)

    # Objective function: Maximize profit
    model.setObjective(3 * S + 5 * L, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(15 * S + 20 * L <= 2000, name="Coffee_Availability")
    model.addConstr(S >= 4 * L, name="Small_to_Large_Ratio")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Small Coffee Pods = {S.varValue}, Large Coffee Pods = {L.varValue}")
        print(f"Maximum Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_coffee_pod_problem()
