
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("dessert_optimization")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="cupcakes") # Number of cupcake batches
y = m.addVar(vtype=GRB.CONTINUOUS, name="cakes") # Number of cake batches

# Set objective function
m.setObjective(10*x + 25*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 60*y <= 9000, "oven_time")
m.addConstr(60*x + 120*y <= 12000, "cooling_time")
m.addConstr(x >= 0, "cupcakes_nonnegative")  # Explicit non-negativity constraints
m.addConstr(y >= 0, "cakes_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of cupcake batches (x): {x.x}")
    print(f"Number of cake batches (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {m.status}")

