
from gurobipy import *

# Create a new model
m = Model("Dessert_Optimization")

# Define the decision variables
x = m.addVar(vtype=GRB.INTEGER, name="cupcakes")
y = m.addVar(vtype=GRB.INTEGER, name="cakes")

# Set the objective function
m.setObjective(10*x + 25*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 60*y <= 9000, "oven_time")
m.addConstr(60*x + 120*y <= 12000, "cooling_rack_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {int(x.x)} batches, {y.varName} = {int(y.x)} batches")
    print(f"Maximum profit: ${10*x.x + 25*y.x}")
else:
    print("No optimal solution found")
