
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
cupcakes = m.addVar(lb=0, name="cupcakes", vtype=gurobi.GRB.CONTINUOUS)
cakes = m.addVar(lb=0, name="cakes", vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(10 * cupcakes + 25 * cakes, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(20 * cupcakes + 60 * cakes <= 9000, name="oven_time")
m.addConstr(60 * cupcakes + 120 * cakes <= 12000, name="cooling_rack_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Cupcakes: {cupcakes.varValue:.2f}")
    print(f"Cakes: {cakes.varValue:.2f}")
    print(f"Max Profit: {m.objVal:.2f}")
else:
    print("No optimal solution found.")
