
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("soil_mix")

# Create variables
x = model.addVar(lb=0, name="indoor_soil")  # Indoor soil
y = model.addVar(lb=0, name="outdoor_soil") # Outdoor soil

# Set objective function
model.setObjective(2*x + 3*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(2*x + 4*y >= 80, "compost_req")
model.addConstr(3*x + 6*y >= 70, "loam_req")

# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal Cost: ${model.objVal}")
    print(f"Indoor Soil: {x.x} units")
    print(f"Outdoor Soil: {y.x} units")

