
from gurobipy import *

# Create a new model
m = Model("Soil_Mix_Problem")

# Define variables
x1 = m.addVar(name="indoor_soil", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="outdoor_soil", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(2*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 4*x2 >= 80, name="compost_requirement")
m.addConstr(3*x1 + 6*x2 >= 70, name="loam_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("The model is infeasible")
