
import gurobi

def solve_soil_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="indoor_soil", lb=0)  # Amount of indoor soil
    y = model.addVar(name="outdoor_soil", lb=0)  # Amount of outdoor soil

    # Objective function: Minimize cost
    model.setObjective(2*x + 3*y, gurobi.GRB.MINIMIZE)

    # Constraints: Meet compost and loam requirements
    model.addConstr(2*x + 4*y >= 80, name="compost_requirement")
    model.addConstr(3*x + 6*y >= 70, name="loam_requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal amount of indoor soil: {x.varValue}")
        print(f"Optimal amount of outdoor soil: {y.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("No optimal solution found")

solve_soil_mix_problem()
