
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("advertising_optimization")

# Create variables
n = m.addVar(vtype=GRB.INTEGER, name="newspaper_ads")
r = m.addVar(vtype=GRB.INTEGER, name="radio_ads")
t = m.addVar(vtype=GRB.INTEGER, name="tv_ads")

# Set objective function
m.setObjective(5000*n + 1000*r + 8000*t, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1200*n + 500*r + 2000*t <= 100000, "budget_constraint")
m.addConstr(r <= 10, "radio_limit")
m.addConstr(t <= (n + r + t)/3, "tv_proportion")
m.addConstr(n >= 0.2*(n + r + t), "newspaper_proportion")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of newspaper ads: {n.x}")
    print(f"Optimal number of radio ads: {r.x}")
    print(f"Optimal number of TV ads: {t.x}")
    print(f"Total expected viewers: {m.objVal}")
else:
    print("No solution found.")

