
from gurobipy import *

# Create a model
m = Model("Theta_Sandwich_Optimization")

# Decision variables
N = m.addVar(vtype=GRB.INTEGER, name="Newspaper_Ads")
R = m.addVar(vtype=GRB.INTEGER, name="Radio_Ads")
T = m.addVar(vtype=GRB.INTEGER, name="Television_Ads")

# Objective function: Maximize total viewership
m.setObjective(5000*N + 1000*R + 8000*T, GRB.MAXIMIZE)

# Constraints
# Budget constraint
m.addConstr(1200*N + 500*R + 2000*T <= 100000, name="Budget")

# Radio ads limit
m.addConstr(R <= 10, name="Radio_Ads_Limit")

# Television ads fraction
m.addConstr(T <= (1/3)*(N + R + T), name="Television_Ads_Fraction")

# Newspaper ads fraction
m.addConstr(N >= 0.2*(N + R + T), name="Newspaper_Ads_Fraction")

# Non-negativity constraints are implicitly handled by GRB.INTEGER with lower bound at 0

# Solve the model
m.optimize()

# Print results if optimal solution is found
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of Newspaper Ads: {N.x}")
    print(f"Optimal number of Radio Ads: {R.x}")
    print(f"Optimal number of Television Ads: {T.x}")
else:
    print("No optimal solution found")
