
import gurobi

def solve_ads_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="newspaper_ads", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="radio_ads", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="television_ads", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize the total number of viewers
    model.setObjective(5000*x1 + 1000*x2 + 8000*x3, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(1200*x1 + 500*x2 + 2000*x3 <= 100000, name="budget_constraint")

    # Radio ad limitation
    model.addConstr(x2 <= 10, name="radio_limitation")

    # Television ad limitation
    model.addConstr(2*x3 <= x1 + x2, name="television_limitation")

    # Newspaper ad requirement
    model.addConstr(4*x1 >= x2 + x3, name="newspaper_requirement")

    # Non-negativity constraints (implicit for Gurobi with vtype=INTEGER)

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal Solution:")
        print(f"Newspaper Ads: {x1.varValue}")
        print(f"Radio Ads: {x2.varValue}")
        print(f"Television Ads: {x3.varValue}")
        print(f"Max Viewers: {5000*x1.varValue + 1000*x2.varValue + 8000*x3.varValue}")
    else:
        print("The model is infeasible")

solve_ads_optimization()
