
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("CowFeed")

# Create variables
x = m.addVar(lb=0, name="silage") # Kilograms of silage
y = m.addVar(lb=0, name="grains") # Kilograms of mixed grains

# Set objective function
m.setObjective(215*x + 320*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.5*x + 0.2*y >= 100, "Protein")
m.addConstr(0.2*x + 0.1*y <= 50, "Vitamins")
m.addConstr(0.1*x + 0.2*y >= 75, "Minerals")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Kilograms of silage: {x.x:.2f}")
    print(f"Kilograms of mixed grains: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

