
from gurobipy import *

# Create a new model
m = Model("Cow_Feeding")

# Define variables
x_s = m.addVar(name="silage", vtype=GRB.CONTINUOUS, lb=0)
x_m = m.addVar(name="mixed_grains", vtype=GRB.CONTINUOUS, lb=0)

# Objective function: Minimize cost
m.setObjective(215*x_s + 320*x_m, GRB.MINIMIZE)

# Constraints
m.addConstr(0.5*x_s + 0.2*x_m >= 2, name="protein_requirement")
m.addConstr(0.2*x_s + 0.1*x_m <= 1.0, name="vitamin_limitation")
m.addConstr(0.1*x_s + 0.2*x_m >= 1.5, name="mineral_requirement")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Silage per cow: {x_s.x} kg")
    print(f"Mixed grains per cow: {x_m.x} kg")
    print(f"Total cost for 50 cows: ${(215*x_s.x + 320*x_m.x) * 50:.2f}")
else:
    print("No optimal solution found.")
