
import gurobi

def solve_feeding_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Decision variables
    x = model.addVar(name="silage", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="mixed_grains", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: minimize cost
    model.setObjective(215 * x + 320 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.5 * x + 0.2 * y >= 2, name="protein_requirement")
    model.addConstr(0.1 * x + 0.2 * y >= 1.5, name="minerals_requirement")
    model.addConstr(0.2 * x + 0.1 * y <= 1.0, name="vitamins_limit")

    # Solve the problem for one cow
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        silage_per_cow = x.varValue
        mixed_grains_per_cow = y.varValue
        cost_per_cow = 215 * silage_per_cow + 320 * mixed_grains_per_cow
        total_cost = 50 * cost_per_cow  # For 50 cows
        print(f"Silage per cow: {silage_per_cow:.2f} kg")
        print(f"Mixed grains per cow: {mixed_grains_per_cow:.2f} kg")
        print(f"Cost per cow: ${cost_per_cow:.2f}")
        print(f"Total cost for 50 cows: ${total_cost:.2f}")
    else:
        print("No optimal solution found.")

solve_feeding_problem()
