
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Problem")

# Create variables
x = m.addVar(nonnegative=True, name="logging")  # Investment in logging
y = m.addVar(nonnegative=True, name="shipping") # Investment in shipping

# Set objective function
m.setObjective(0.06 * x + 0.03 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 3000, "Total_Investment")
m.addConstr(x >= 0.5 * 3000, "Min_Logging")
m.addConstr(y >= 1000, "Min_Shipping")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in logging: ${x.x:.2f}")
    print(f"Optimal investment in shipping: ${y.x:.2f}")
    print(f"Maximum profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

