
from gurobipy import *

# Create a new model
m = Model("Investment_Problem")

# Define variables
L = m.addVar(name="Logging_Investment", lb=0)  # Amount invested in logging
S = m.addVar(name="Shipping_Investment", lb=0)  # Amount invested in shipping

# Objective function: Maximize profit
m.setObjective(0.06 * L + 0.03 * S, GRB.MAXIMIZE)

# Constraints
m.addConstr(L + S <= 3000, name="Total_Investment")  # Total investment limit
m.addConstr(L >= 0.5 * (L + S), name="Logging_Minimum_Percentage")
m.addConstr(S >= 1000, name="Shipping_Minimum_Investment")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Logging Investment: ${L.x:.2f}")
    print(f"Shipping Investment: ${S.x:.2f}")
    print(f"Maximum Profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found.")
