
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="logging_investment", lb=0)
    x2 = model.addVar(name="shipping_investment", lb=0)

    # Objective function: Maximize 0.06x1 + 0.03x2
    model.setObjective(0.06 * x1 + 0.03 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 3000, name="total_investment")
    model.addConstr(x1 >= 1500, name="min_logging_investment")
    model.addConstr(x2 >= 1000, name="min_shipping_investment")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Logging Investment: ${model.cbGetSolution(x1):.2f}")
        print(f"Shipping Investment: ${model.cbGetSolution(x2):.2f}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
